<?php
/**
 * Гостевая гнига на файлах AGB!
 * Автор: Jeey
 * Email: jeey@mail.ru
 * ICQ: 9510787
 * Сайт: http://jeey.ru
 */

// Функция для фильтрации переменных
date_default_timezone_set('Europe/Moscow');
function clean($str, $maxlength, $default = '')
{
    if( !is_string($str) )
    {
        return $default;
    }

    $str = iconv_substr(trim(htmlentities($str, ENT_QUOTES, 'UTF-8')), 0, $maxlength, 'UTF-8');
    $str = str_replace('|', '&#124;', $str);
    $str = str_replace('\\', '&#92;', $str);

    return $str;
}

// Функция для преобразования даты

function today($date)
{
    if( $date == date('j.m') )
    {
        return 'Сегодня';
    }

    $month = array
    (
        '.01' => ' Января',
        '.02' => ' Февраля',
        '.03' => ' Марта',
        '.04' => ' Апреля',
        '.05' => ' Мая',
        '.06' => ' Июня',
        '.07' => ' Июля',
        '.08' => ' Августа',
        '.09' => ' Сентября',
        '.10' => ' Октября',
        '.11' => ' Ноября',
        '.12' => ' Декабря'
    );

    return str_replace(array_keys($month), array_values($month), $date);
}

// Функция для записи в файл

function puts($path, $data, $mode)
{
    $fp = fopen($path, $mode);
    flock($fp, LOCK_EX);
    fputs($fp, $data);
    flock($fp, LOCK_UN);
    fclose($fp);
}

################################################################################
#
#       Антимат
#
################################################################################
function antimat($text){
    $file=file($_SERVER['DOCUMENT_ROOT'].'/guestbook/data/antimat.dat');
    foreach($file as $key=>$val){
        $exp=explode('|', $val);
        $text=preg_replace('/'.$exp[0].'/iu', '***', $text);
    }
    return $text;
}
?>